% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_analysis}
\alias{example_analysis}
\title{Example of writership analysis}
\format{
The results of \code{\link[=analyze_questioned_documents]{analyze_questioned_documents()}} stored in a named list with 5 items:
\describe{
\item{graph_measurements}{A data frame of that shows the writer, document name, cluster assignment,
slope, principle component rotation angle, and wrapped principle component rotation angle for each training graph in each
questioned documents.}
\item{cluster_fill_counts}{A data frame of the cluster fill counts for each questioned document.}
\item{likelihoods}{A list of data frames where each data frame
contains the likelihoods for a questioned document for each MCMC iteration.}
\item{votes}{A list of vote tallies for each questioned document.}
\item{posterior_probabilites}{A list of posterior probabilities of writership
for each questioned document and each known writer in the closed set used to train the
hierarchical model.}
}
}
\usage{
example_analysis
}
\description{
Example of writership analysis
}
\examples{
plot_cluster_fill_counts(formatted_data = example_analysis)
plot_posterior_probabilities(analysis = example_analysis)

}
\keyword{datasets}
