% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootPerformance.R
\name{bootPerformance}
\alias{bootPerformance}
\title{bootPerformance}
\usage{
bootPerformance(model, df, metric, n = 100)
}
\arguments{
\item{model}{a model trained by h2o machine learning software}

\item{df}{training, validation, or testing dataset to bootstrap from}

\item{metric}{character. model evaluation metric to be passed to boot R package.
this could be, for example "AUC", "AUCPR", RMSE", etc., depending
of the model you have trained. all evaluation metrics provided
for your H2O models can be specified here.}

\item{n}{number of bootstraps}
}
\value{
list of mean perforance of the specified metric and other bootstrap results
}
\description{
Evaluate model performance by bootstrapping from training dataset
}
\examples{

\dontrun{
library(h2o)
h2o.init(ignore_config = TRUE, nthreads = 2, bind_to_localhost = FALSE, insecure = TRUE)
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
df <- read.csv(prostate_path)

# prepare the dataset for analysis before converting it to h2o frame.
df$CAPSULE <- as.factor(df$CAPSULE)

# convert the dataframe to H2OFrame and run the analysis
prostate.hex <- as.h2o(df)
aml <- h2o.automl(y = "CAPSULE", training_frame = prostate.hex, max_runtime_secs = 30)

# evaluate the model performance
perf <- h2o.performance(aml@leader, xval = TRUE)

# evaluate bootstrap performance for the training dataset
#    NOTE that the raw data is given not the 'H2OFrame'
perf <- bootPerformance(model = aml@leader, df = df, metric = "RMSE", n = 500)
}
}
\author{
E. F. Haghish
}
