% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.multinomial_auc_table}
\alias{h2o.multinomial_auc_table}
\title{Retrieve the all AUC values in a table (One to Rest, One to One, macro and weighted average) 
for mutlinomial classification.}
\usage{
h2o.multinomial_auc_table(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OMultinomialMetrics} object.}

\item{train}{Retrieve the training AUC table}

\item{valid}{Retrieve the validation AUC table}

\item{xval}{Retrieve the cross-validation AUC table}
}
\description{
Retrieves the AUC table from an \linkS4class{H2OMultinomialMetrics}.
If "train", "valid", and "xval" parameters are FALSE (default), then the training AUC table is returned. If more
than one parameter is set to TRUE, then a named vector of AUC tables are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(prostate_path)

prostate[, 2] <- as.factor(prostate[, 2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = prostate, distribution = "bernoulli")
perf <- h2o.performance(model, prostate)
h2o.multinomial_auc_table(perf)
}
}
\seealso{
\code{\link{h2o.giniCoef}} for the Gini coefficient,
         \code{\link{h2o.mse}} for MSE, and \code{\link{h2o.metric}} for the
         various threshold metrics. See \code{\link{h2o.performance}} for
         creating H2OModelMetrics objects.
}
