% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregator.R
\name{h2o.aggregator}
\alias{h2o.aggregator}
\title{Build an Aggregated Frame}
\usage{
h2o.aggregator(
  training_frame,
  x,
  model_id = NULL,
  ignore_const_cols = TRUE,
  target_num_exemplars = 5000,
  rel_tol_num_exemplars = 0.5,
  transform = c("NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE"),
  categorical_encoding = c("AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
    "Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited"),
  save_mapping_frame = FALSE,
  num_iteration_without_new_exemplar = 500,
  export_checkpoints_dir = NULL
)
}
\arguments{
\item{training_frame}{Id of the training data frame.}

\item{x}{A vector containing the \code{character} names of the predictors in the model.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{target_num_exemplars}{Targeted number of exemplars Defaults to 5000.}

\item{rel_tol_num_exemplars}{Relative tolerance for number of exemplars (e.g, 0.5 is +/- 50 percents) Defaults to 0.5.}

\item{transform}{Transformation of training data Must be one of: "NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE".
Defaults to NORMALIZE.}

\item{categorical_encoding}{Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
"Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.}

\item{save_mapping_frame}{\code{Logical}. Whether to export the mapping of the aggregated frame Defaults to FALSE.}

\item{num_iteration_without_new_exemplar}{The number of iterations to run before aggregator exits if the number of exemplars collected didn't change
Defaults to 500.}

\item{export_checkpoints_dir}{Automatically export generated models to this directory.}
}
\description{
Builds an Aggregated Frame of an H2OFrame.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
df <- h2o.createFrame(rows = 100, 
                      cols = 5, 
                      categorical_fraction = 0.6, 
                      integer_fraction = 0,
                      binary_fraction = 0, 
                      real_range = 100, 
                      integer_range = 100, 
                      missing_fraction = 0)
target_num_exemplars = 1000
rel_tol_num_exemplars = 0.5
encoding = "Eigen"
agg <- h2o.aggregator(training_frame = df,
                     target_num_exemplars = target_num_exemplars,
                     rel_tol_num_exemplars = rel_tol_num_exemplars,
                     categorical_encoding = encoding)
}
}
