% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.get_segment_models}
\alias{h2o.get_segment_models}
\title{Retrieves an instance of \linkS4class{H2OSegmentModels} for a given id.}
\usage{
h2o.get_segment_models(segment_models_id)
}
\arguments{
\item{segment_models_id}{A string indicating the unique segment_models_id}
}
\value{
Returns an object that is a subclass of \linkS4class{H2OSegmentModels}.
}
\description{
Retrieves an instance of \linkS4class{H2OSegmentModels} for a given id.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
iris_hf <- as.h2o(iris)
h2o.train_segments(algorithm = "gbm",
                   segment_columns = "Species", segment_models_id="models_by_species",
                   x = c(1:3), y = 4, training_frame = iris_hf, ntrees = 5, max_depth = 4)
models <- h2o.get_segment_models("models_by_species")
as.data.frame(models)
}
}
