\name{h2o-package}
\alias{h2o-package}
\alias{h2o}
\docType{package}
\title{
H2O R Interface
}
\description{
This is a package for running H2O via its REST API from within R. To communicate with a H2O instance, the version of the R package must match the version of H2O. When connecting to a new H2O cluster, it is necessary to re-run the initializer.
}
\details{
\tabular{ll}{
Package: \tab h2o\cr
Type: \tab Package\cr
Version: \tab 3.32.0.1\cr
Branch: \tab rel-zermelo\cr
Date: \tab Thu Oct 08 18:19:56 UTC 2020\cr
License: \tab Apache License (== 2.0)\cr
Depends: \tab R (>= 2.13.0), RCurl, jsonlite, statmod, tools, methods, utils\cr
}

H2O is the scalable open source machine learning platform that offers parallelized implementations of many supervised and unsupervised machine learning algorithms such as Generalized Linear Models (GLM), Gradient Boosting Machines (including XGBoost), Random Forests, Deep Neural Networks (Deep Learning), Stacked Ensembles, Naive Bayes, Generalized Additive Models (GAM), Cox Proportional Hazards, K-Means, PCA, Word2Vec, as well as a fully automatic machine learning algorithm (H2O AutoML).  As an example, to run GLM, call \code{\link{h2o.glm}} with the H2O parsed data and parameters (response variable, error distribution, etc.) as arguments.

This package enables the use of the H2O machine learning platform commands in R.  To use H2O from R, you must start or connect to the "H2O cluster", the term we use to describe the backend H2O Java engine. To run H2O on your local machine, call \code{\link{h2o.init}} without any arguments, and H2O will be automatically launched at localhost:54321, where the IP is "127.0.0.1" and the port is 54321. If you have the H2O cluster running on a remote machine (e.g. AWS EC2), you must provide the IP and port of the remote machine as arguments to the \code{\link{h2o.init}} call.

Note that no actual data is stored in the R workspace; and no actual work is carried out by R. R only saves the named objects, which uniquely identify the data set, model, etc on the server. When the user makes a request, R queries the server via the REST API, which returns a JSON file with the relevant information that R then displays in the console.

}
\author{
Maintainer: Erin LeDell <erin@h2o.ai>
}
\references{
\itemize{
  \item \href{https://www.h2o.ai}{H2O.ai Homepage}
  \item \href{https://docs.h2o.ai/h2o/latest-stable/h2o-docs/index.html}{H2O User Guide}
  \item \href{https://github.com/h2oai/h2o-3}{H2O on GitHub}
  }
}
\keyword{ package }
