% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.std_coef_plot}
\alias{h2o.std_coef_plot}
\title{Plot Standardized Coefficient Magnitudes}
\usage{
h2o.std_coef_plot(model, num_of_features = NULL)
}
\arguments{
\item{model}{A trained generalized linear model}

\item{num_of_features}{The number of features to be shown in the plot}
}
\description{
Plot a GLM model's standardized coefficient magnitudes.
}
\examples{
\donttest{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.importFile(prosPath)
prostate.hex[,2] <- as.factor(prostate.hex[,2])
prostate.glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"),
                         training_frame = prostate.hex, family = "binomial",
                         nfolds = 0, alpha = 0.5, lambda_search = FALSE)
h2o.std_coef_plot(prostate.glm)
}
}
\seealso{
\code{\link{h2o.varimp_plot}} for variable importances plot of
         random forest, GBM, deep learning.
}

