% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.stackedEnsemble}
\alias{h2o.stackedEnsemble}
\title{Build a stacked ensemble (aka. Super Learner) using the H2O base
learning algorithms specified by the user.}
\usage{
h2o.stackedEnsemble(x, y, training_frame, model_id = NULL,
  validation_frame = NULL, base_models = list(),
  selection_strategy = c("choose_all"))
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing,then all columns except y are used.}

\item{y}{The name of the response variable in the model.If the data does not contain a header, this is the first column
index, and increasing from left to right. (The response must be either an integer or a
categorical variable).}

\item{training_frame}{Id of the training data frame (Not required, to allow initial validation of model parameters).}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{base_models}{List of model ids which we can stack together.  Which ones are chosen depends on the selection_strategy
(currently, all models will be used since selection_strategy can only be set to choose_all).  Models must have
been cross-validated using nfolds > 1, fold_assignment equal to Modulo, and keep_cross_validation_folds must
be set to True. Defaults to [].}

\item{selection_strategy}{Strategy for choosing which models to stack. Must be one of: "choose_all".}
}
\description{
Build a stacked ensemble (aka. Super Learner) using the H2O base
learning algorithms specified by the user.
}
\examples{
# See example R code here:
# http://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/stacked-ensembles.html
}

