# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- word2vec -------------------------- #
#' 
#' Trains a word2vec model on a String column of an H2O data frame.
#' 
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param training_frame Id of the training data frame (Not required, to allow initial validation of model parameters).
#' @param min_word_freq This will discard words that appear less than <int> times Defaults to 5.
#' @param word_model Use the Skip-Gram model Must be one of: "SkipGram". Defaults to SkipGram.
#' @param norm_model Use Hierarchical Softmax Must be one of: "HSM". Defaults to HSM.
#' @param vec_size Set size of word vectors Defaults to 100.
#' @param window_size Set max skip length between words Defaults to 5.
#' @param sent_sample_rate Set threshold for occurrence of words. Those that appear with higher frequency in the training data
#'        will be randomly down-sampled; useful range is (0, 1e-5) Defaults to 0.001.
#' @param init_learning_rate Set the starting learning rate Defaults to 0.025.
#' @param epochs Number of training iterations to run Defaults to 5.
#' @export
h2o.word2vec <- function(training_frame,
                         model_id = NULL,
                         min_word_freq = 5,
                         word_model = c("SkipGram"),
                         norm_model = c("HSM"),
                         vec_size = 100,
                         window_size = 5,
                         sent_sample_rate = 0.001,
                         init_learning_rate = 0.025,
                         epochs = 5
                         ) 
{

  # Required args: training_frame
  if( missing(training_frame) ) stop("argument 'training_frame' is missing, with no default")
  # Training_frame must be a key or an H2OFrame object
  if (!is.H2OFrame(training_frame))
     tryCatch(training_frame <- h2o.getFrame(training_frame),
           error = function(err) {
             stop("argument 'training_frame' must be a valid H2OFrame or key")
           })
  # Parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(min_word_freq))
    parms$min_word_freq <- min_word_freq
  if (!missing(word_model))
    parms$word_model <- word_model
  if (!missing(norm_model))
    parms$norm_model <- norm_model
  if (!missing(vec_size))
    parms$vec_size <- vec_size
  if (!missing(window_size))
    parms$window_size <- window_size
  if (!missing(sent_sample_rate))
    parms$sent_sample_rate <- sent_sample_rate
  if (!missing(init_learning_rate))
    parms$init_learning_rate <- init_learning_rate
  if (!missing(epochs))
    parms$epochs <- epochs
  # Error check and build model
  .h2o.modelJob('word2vec', parms, h2oRestApiVersion=3) 
}
