% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{prepareComputePlan}
\alias{prepareComputePlan}
\title{Return a suitable compute plan for a genome-wide association study}
\usage{
prepareComputePlan(
  model,
  snpData,
  out = "out.log",
  ...,
  SNP = NULL,
  startFrom = 1L,
  rowFilter = NULL
)
}
\arguments{
\item{model}{an \link[OpenMx:MxModel-class]{MxModel} model, specified using RAM 
or LISREL notation. The model argument is designed to take the output 
from e.g. buildOneFac (or the other prebuilt GW-SEM functions), but 
advanced users can specify their own arbitrary OpenMx Model or use Onyx 
to draw their path diagrams.}

\item{snpData}{a pathway to a file containing GWAS data. The data can be 
in a variety of forms, such as standard PLINK format (bed/bim/fam), 
PLINK2 format (pgen/pvar/psam), Oxford format (bgen/sample), or CSV 
format (csv format in much slower due to the lack of compression 
for non-binary files).}

\item{out}{a file name or pathway where the output from the analysis will be saved. 
The default pathway is "out.log", which will save the file in the working 
directory. Users should take caution when specifying the output file name so 
that the output from different analyses/chromosomes do not overwrite existing files.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{SNP}{a numerical range that specifies the number of SNPs to be evaluated 
from the snpData file. This argument can be used to evaluate a subset of 
snps for model testing. e.g. 1:10 will run the first 10 snps to make sure 
that the model is functioning the way the users intends, that the files 
exist pathways are correct. This option is also very useful to specify a 
range of snps to be evaluated that is smaller than the complete file. For 
example, users may wish to run several discrete batches of analyses for 
chromosome 1, by running 1:10000, 100001:200000, etc. This prevents users 
from constructing numerous snap files for each chromosome. The default 
value of the SNP argument is NULL, which will run all snps in the file.}

\item{startFrom}{a numerical value indicating which SNP is the first SNP to be analyzed. The function will then run every SNP from the specified SNP to the end of the GWAS data file. This is very useful if the analysis stops for some reason (i.e. the cluster is restarted for maintenance) and you can start from the last SNP that you analyzed. Note, you will want to label the output file (specified in out) with a new file name so that you don't overwrite the existing results.}

\item{rowFilter}{optional named list of logical vectors to indicate which rows to skip when loading the SNP column}
}
\value{
The given model with an appropriate compute plan.
}
\description{
\lifecycle{maturing}
Instead of using OpenMx's default model processing sequence (i.e.,
\link[OpenMx]{omxDefaultComputePlan}), it is more efficient and
convienient to assemble a compute plan tailored for a genome-wide
association study.  This function returns a compute plan that loads
SNP data into model \code{modelName}, fits the model, outputs the
results to \code{out}, and repeats this procedure for all SNPs.
}
\details{
You can request a specific list of SNPs using the \code{SNP}
argument. The numbers provided in \code{SNP} refer to offsets in
the \code{snpData} file. For example, \code{SNP=c(100,200)} will
process the 100th and 200th SNP. The first SNP in the
\code{snpData} file is at offset 1. When \code{SNP} is omitted then
all available SNPs are processed.

The suffix of \code{snpData} filename is interpreted to signal the
format of how the SNP data is stored on disk. Suffixes
\sQuote{pgen}, \sQuote{bed}, and \sQuote{bgen} are supported.
Per-SNP descriptions are found in different places depending on the
suffix. For \sQuote{bgen}, both the SNP data and description are
built into the same file. In the case of \sQuote{pgen}, an
associated file with suffix \sQuote{pvar} is expected to exist (see
the
\href{https://www.cog-genomics.org/plink/2.0/formats#pvar}{spec}
for details). In the case of \sQuote{bed}, an associated
\sQuote{bim} file is expected to exist (see the
\href{https://www.cog-genomics.org/plink2/formats#bim}{spec} for
details). The chromosome, base-pair coordinate, and variant ID are
added to each line of \code{out}.

The code to implement method='pgen' is based on plink 2.0
alpha. plink's \sQuote{bed} file format is supported in addition
to \sQuote{pgen}. Data are coerced appropriately depending on the
type of the destination column. For a numeric column, data are
recorded as the values NA, 0, 1, or 2. An ordinal column must have
exactly 3 levels.

For \code{method='bgen'}, the file \code{path+".bgi"} must also
exist. If not available, generate this index file with the
\href{https://bitbucket.org/gavinband/bgen/wiki/bgenix}{bgenix}
tool.

For \sQuote{bgen} and \sQuote{pgen} formats, the numeric column can be
populated with a dosage (sum of probabilities multiplied by genotypes)
if these data are available.

A compute plan does not do anything by itself. You'll need to combine
the compute plan with a model (such as returned by \link{buildOneFac})
to perform a GWAS.
}
\examples{
pheno <- data.frame(anxiety=cut(rnorm(500), c(-Inf, -.5, .5, Inf),
ordered_result = TRUE))
m1 <- buildItem(pheno, 'anxiety')
dir <- system.file("extdata", package = "gwsem")
m1 <- prepareComputePlan(m1, file.path(dir,"example.bgen"))
m1$compute
}
\seealso{
\link{GWAS}
}
