% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{setupExogenousCovariates}
\alias{setupExogenousCovariates}
\title{Set up exogenous model covariates}
\usage{
setupExogenousCovariates(model, covariates, itemNames)
}
\arguments{
\item{model}{A fully specified \link[OpenMx:MxModel-class]{MxModel} object that can be fit to each SNP.}

\item{covariates}{a character vector naming covariates available in the model data}

\item{itemNames}{a character vector of item names}
}
\value{
The given \link[OpenMx:MxModel-class]{MxModel} with paths
added from covariates to manifest indicators.
}
\description{
In GWAS, including a number of the first principle components as
covariates helps reduce false positives caused by population
stratification. This function adds paths from covariates to
manifest indicators (\code{itemNames}). Covariates are always treated as continuous
variables (not ordinal).
}
\details{
This is not the only way to adjust a model for
covariates. For example, in a single factor model (e.g., \link{buildOneFac}),
it would be more
appropriate to adjust the latent factor instead of the manifest
indicators.
This is how endogenous covariates work.
However, exogenous covariate adjustments to latent variables are only
possible with a maximum likelihood fit function
(\link[OpenMx]{mxFitFunctionML}).  For
\link[OpenMx]{mxFitFunctionWLS}, only manifest indicators can be
adjusted for exogenous covariates.
This function always adjusts manifest indicators regardless of the fit function.

You generally do not need to call this function directly because it
is already called by \link{buildOneFac} and similar. This
function is provided for advanced users who wish to write their own
model building functions.
}
\examples{
m1 <- mxModel("test", type="RAM",
             latentVars = "sex", manifestVars = "anxiety")
m1 <- setupExogenousCovariates(m1, 'sex', 'anxiety')
}
