% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.elliptical.R
\name{anova.elliptical}
\alias{anova.elliptical}
\title{Analysis of Deviance for Elliptical Model Fits}
\usage{
\method{anova}{elliptical}(object, ..., dispersion = NULL, test = c("Chisq"))
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{...}{additional objects of the same type.}

\item{dispersion}{the dispersion parameter for the fitting family. If is \code{NULL} (by default) is obtained from object.}

\item{test}{a character string containing the hypothesis test considered. By default is used the chi-square test.}
}
\value{
Return an object of class \dQuote{anova}. This object contain the analysis of deviance.
}
\description{
Compute an analysis of deviance table for the fitted elliptical regression model.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
anova(elliptical.fitt, test = "Chisq")
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{elliptical}}, \code{\link{summary.elliptical}}, \code{\link{family.elliptical}}
}
\keyword{ANOVA}
\keyword{Elliptical}
\keyword{Hypothesis}
\keyword{models}
\keyword{tests}
