% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_associations.R
\name{get_associations_by_efo_id}
\alias{get_associations_by_efo_id}
\title{Get GWAS Catalog associations by EFO identifier}
\usage{
get_associations_by_efo_id(
  efo_id = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{page_size}{An \code{integer} scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{associations} object.
}
\description{
Gets associations whose phenotypic trait is matched by EFO identifiers.
}
\keyword{internal}
