% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-variants.R
\docType{class}
\name{variants-class}
\alias{variants-class}
\title{An S4 class to represent a set of GWAS Catalog variants}
\description{
The variants object consists of four slots, each a table
(\code{\link[tibble]{tibble}}), that combined form a relational database of a
subset of GWAS Catalog variants. Each variant is an observation (row) in the
\code{variants} table --- main table. All tables have the column
\code{variant_id} as primary key.
}
\section{Slots}{

\describe{
\item{\code{variants}}{A \code{\link[tibble]{tibble}} listing variants. Columns:
\describe{
\item{variant_id}{Variant identifier, e.g., \code{'rs1333048'}.}
\item{merged}{Whether this SNP has been merged with another SNP in a newer
genome build.}
\item{functional_class}{Class according to Ensembl's predicted consequences
that each variant allele may have on transcripts. See
\href{https://www.ensembl.org/info/genome/variation/prediction/predicted_data.html}{Ensembl
Variation - Calculated variant consequences}.}
\item{chromosome_name}{Chromosome name.}
\item{chromosome_position}{Chromosome position.}
\item{chromosome_region}{\href{https://medlineplus.gov/genetics/understanding/howgeneswork/genelocation/}{Cytogenetic
location}.}
\item{last_update_date}{Last time this variant was updated.}
}}

\item{\code{genomic_contexts}}{A \code{\link[tibble]{tibble}} listing genomic
  contexts associated with each variant. Columns:
\describe{
\item{variant_id}{Variant identifier.}
\item{gene_name}{Gene symbol according to
\href{https://www.genenames.org/}{HUGO Gene Nomenclature (HGNC)}.}
\item{chromosome_name}{Chromosome name.}
\item{chromosome_position}{Chromosome position.}
\item{distance}{Genomic distance between the variant and the gene (in base
pairs).}
\item{is_mapped_gene}{Whether this is a mapped gene to this variant. A mapped
gene is either an overlapping gene with the variant or the two closest genes
upstream and downstream of the variant. Moreover, only genes whose mapping
source is 'Ensembl' are considered.}
\item{is_closest_gene}{Whether this is the closest gene to this variant.}
\item{is_intergenic}{Whether this variant is intergenic, i.e, if there is no
gene up or downstream within 100kb.}
\item{is_upstream}{Whether this variant is upstream of this gene.}
\item{is_downstream}{Whether this variant is downstream of this gene.}
\item{source}{Gene mapping source, either \code{Ensembl} or \code{NCBI}.}
\item{mapping_method}{Gene mapping method.}
}}

\item{\code{ensembl_ids}}{A \code{\link[tibble]{tibble}} listing gene Ensembl
  identifiers associated with each genomic context. Columns:
\describe{
\item{variant_id}{Variant identifier.}
\item{gene_name}{Gene symbol according to
\href{https://www.genenames.org/}{HUGO Gene Nomenclature (HGNC)}.}
\item{ensembl_id}{The Ensembl identifier of an Ensembl gene, see Section
\href{https://www.ensembl.org/info/genome/genebuild/index.html}{Gene
annotation in Ensembl} for more information.}
}}

\item{\code{entrez_ids}}{A \code{\link[tibble]{tibble}} listing gene Entrez
  identifiers associated with each genomic context. Columns:
\describe{
\item{variant_id}{Variant identifier.}
\item{gene_name}{Gene symbol according to
\href{https://www.genenames.org/}{HUGO Gene Nomenclature (HGNC)}.}
\item{entrez_id}{The Entrez identifier of a gene, see ref.
\doi{10.1093/nar/gkq1237} for
more information.}
}}
}}

