% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{gc_request}
\alias{gc_request}
\title{Request a GWAS Catalog REST API endpoint}
\usage{
gc_request(
  resource_url = "/",
  base_url = gwas_rest_api_base_url,
  verbose = FALSE,
  warnings = TRUE,
  flatten = FALSE
)
}
\arguments{
\item{resource_url}{Endpoint URL. The endpoint is internally appended to the
\code{base_url}. It should start with a forward slash (\code{/}).}

\item{base_url}{The GWAS REST API base URL (one should not need to change its
default value).}

\item{verbose}{Whether to be chatty.}

\item{warnings}{Whether to print warnings.}

\item{flatten}{Whether to flatten out the list returned by
\code{jsonlite::fromJSON}.}
}
\value{
A list four named elements:
\describe{
\item{url}{The URL endpoint.}
\item{response_code}{\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{HTTP
status code}.}
\item{status}{A string describing the status of the response obtained. It is
"OK" if everything went OK or some other string describing the problem
otherwise.}
\item{content}{The parsed JSON as a nested list, as returned by
\code{jsonlite::fromJSON}.}
}
}
\description{
Performs a GET request on the specified \code{resource_url}.
}
\keyword{internal}
