% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvc_gvar.R
\name{gvc_gvar}
\alias{gvc_gvar}
\title{Genotypic Variance}
\usage{
gvc_gvar(y, x = NULL, rep, geno, env, data)
}
\arguments{
\item{y}{Response}

\item{x}{Covariate by default NULL}

\item{rep}{Repliction}

\item{geno}{Genotypic Factor}

\item{env}{Environmental Factor}

\item{data}{data.frame}
}
\value{
Genotypic Variance
}
\description{
gvc_gvar computes genotypic variances
for given traits of different genotypes from replicated data using methodology
 explained by Burton, G. W. & Devane, E. H. (1953) (<doi:10.2134/agronj1953.00021962004500100005x>) and Allard, R.W. (2010, ISBN:8126524154).
}
\examples{
set.seed(12345)
Response <- c(
               rnorm(48, mean = 15000, sd = 500)
             , rnorm(48, mean =  5000, sd = 500)
             , rnorm(48, mean =  1000, sd = 500)
             )
Rep      <- as.factor(rep(1:3, each = 48))
Variety  <- gl(n = 4, k =  4, length = 144, labels = letters[1:4])
Env      <- gl(n = 3, k = 16, length = 144, labels = letters[1:3])
df1      <- data.frame(Response, Rep, Variety, Env)

# Genotypic Variance
gvar <-
 gvc_gvar(
           y    = Response
         , rep  = Rep
         , geno = Variety
         , env  = Env
         , data = df1
         )
gvar

library(eda4treeR)
data(DataExam6.2)
gvar <-
  gvc_gvar(
           y    = Dbh.mean
         , rep  = Replication
         , geno = Family
         , env  = Province
         , data = DataExam6.2
         )
gvar
}
\references{
\enumerate{
         \item R.K. Singh and B.D.Chaudhary
         \emph{Biometrical Methods in Quantitative Genetic Analysis}.
               Kalyani Publishers, New Delhi
             }
\enumerate{
         \item Williams, E.R., Matheson, A.C. and Harwood, C.E. (2002).\emph{Experimental Design and Analysis for Tree Improvement}.
               CSIRO Publishing.
             }
}
\author{
\enumerate{
         \item  Sami Ullah (\email{samiullahuos@gmail.com})
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         }
}
