context("vector length")
library(gunit)

test_that("convert_condunctance returns correct length vectors", {

  g_sw <- units::set_units(1, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw)
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 1L)
  expect_length(g$`umol/m^2/s/Pa`, 1L)
  expect_length(g$`mol/m^2/s`, 1L)

  g_sw <- units::set_units(1:2, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw)
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 2L)
  expect_length(g$`umol/m^2/s/Pa`, 2L)
  expect_length(g$`mol/m^2/s`, 2L)

  g_sw <- units::set_units(1:3, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw)
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 3L)
  expect_length(g$`umol/m^2/s/Pa`, 3L)
  expect_length(g$`mol/m^2/s`, 3L)

  g_sw <- units::set_units(1, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw, Temp = set_units(c(293.15, 298.15), K))
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 2L)
  expect_length(g$`umol/m^2/s/Pa`, 2L)
  expect_length(g$`mol/m^2/s`, 2L)

  g_sw <- units::set_units(1, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw, Temp = set_units(c(293.15, 298.15, 303.15), K))
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 3L)
  expect_length(g$`umol/m^2/s/Pa`, 3L)
  expect_length(g$`mol/m^2/s`, 3L)
  expect_length(unique(g$`m/s`), 3L)
  expect_length(unique(g$`umol/m^2/s/Pa`), 1L)
  expect_length(unique(g$`mol/m^2/s`), 1L)

  g_sw <- units::set_units(1:3, "umol/m^2/s/Pa")
  g <- convert_conductance(g_sw, Temp = set_units(c(293.15, 298.15, 303.15), K))
  expect_equal(ncol(g), 3L)
  expect_length(g$`m/s`, 3L)
  expect_length(g$`umol/m^2/s/Pa`, 3L)
  expect_length(g$`mol/m^2/s`, 3L)
  expect_length(unique(g$`m/s`), 3L)
  expect_length(unique(g$`umol/m^2/s/Pa`), 3L)
  expect_length(unique(g$`mol/m^2/s`), 3L)

})
