% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_row_type.R
\name{remove_row_type}
\alias{remove_row_type}
\title{Remove rows}
\usage{
remove_row_type(
  x,
  variables = everything(),
  type = c("header", "reference", "missing", "level", "all"),
  level_value = NULL
)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to to remove rows from. Default is \code{everything()}}

\item{type}{(\code{string})\cr
Type of row to remove. Must be one of \code{c("header", "reference", "missing", "level", "all")}}

\item{level_value}{(\code{string})
When \code{type='level'} you can specify the \emph{character} value of the level to remove.
When \code{NULL} all levels are removed.}
}
\value{
Modified gtsummary table
}
\description{
Removes either the header, reference, or missing rows from a gtsummary table.
}
\examples{
# Example 1 ----------------------------------
trial |>
  dplyr::mutate(
    age60 = ifelse(age < 60, "<60", "60+")
  ) |>
  tbl_summary(by = trt, missing = "no", include = c(trt, age, age60)) |>
  remove_row_type(age60, type = "header")
}
