% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibbleS3}
\alias{as_tibbleS3}
\alias{as_tibble.gtsummary}
\title{Convert gtsummary object to tibble}
\usage{
\method{as_tibble}{gtsummary}(x, include = everything(), col_labels = TRUE, exclude = NULL, ...)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}, which includes all commands in \code{x$kable_calls}.}

\item{col_labels}{Logical argument adding column labels to output tibble.
Default is \code{TRUE}.}

\item{exclude}{DEPRECATED}

\item{...}{Not used}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Function converts gtsummary objects tibbles. The formatting stored in
\code{x$kable_calls} is applied.
}
\examples{
tbl <-
  trial \%>\%
  tbl_summary(by = trt)

as_tibble(tbl)

# without column labels
as_tibble(tbl, col_names = FALSE)
}
\seealso{
\link{tbl_summary} \link{tbl_regression} \link{tbl_uvregression} \link{tbl_survival}
}
\author{
Daniel D. Sjoberg
}
