% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_gtfs.R
\name{validate_gtfs}
\alias{validate_gtfs}
\title{Validate GTFS feed}
\usage{
validate_gtfs(
  gtfs,
  output_path,
  validator_path,
  overwrite = TRUE,
  html_preview = TRUE,
  pretty_json = FALSE,
  quiet = TRUE,
  n_threads = 1
)
}
\arguments{
\item{gtfs}{The GTFS to be validated. Can be in the format of a GTFS object,
of a path to a GTFS file, of a path to a directory or an URL to a feed.}

\item{output_path}{A string. The path to the directory that the validator
will create and in which the results will be saved to.}

\item{validator_path}{A string. The path to the GTFS validator, previously
downloaded with \code{\link[=download_validator]{download_validator()}}.}

\item{overwrite}{A logical. Whether to overwrite existing validation results
in \code{output_path}. Defaults to \code{TRUE}.}

\item{html_preview}{A logical. Whether to show HTML report in a viewer, such
as RStudio or a browser. Defaults to \code{TRUE} (only works on interactive
sessions).}

\item{pretty_json}{A logical. Whether JSON results should be printed in a
readable way, that allows it to be inspected without manually formatting.
Defaults to \code{FALSE}.}

\item{quiet}{A logical. Whether to hide informative messages. Defaults to
\code{TRUE}.}

\item{n_threads}{An integer between 1 and the number of cores in the running
machine. Control how many threads are used during the validation. Defaults
to using all but one of the available cores.}
}
\value{
Invisibly returns the normalized path to the directory where the
validation results were saved to.
}
\description{
Uses MobilityData's \href{https://github.com/MobilityData/gtfs-validator}{GTFS validator} to perform a GTFS
business rule validation. The results are available as an HTML report (if
validator v3.1.0 or higher is used) and in JSON format. Please check the
complete set of rules used in the validation
\href{https://github.com/MobilityData/gtfs-validator/blob/master/RULES.md}{here}.
Please note that this function requires a working installation of Java 11 or
higher to work.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
output_path <- tempfile("validation_result")
validator_path <- download_validator(tempdir())
gtfs <- read_gtfs(data_path)

validate_gtfs(gtfs, output_path, validator_path)
list.files(output_path)

# works with feeds saved to disk
new_output_path <- tempfile("new_validation_result")
validate_gtfs(data_path, new_output_path, validator_path)
list.files(new_output_path)

# and with feeds pointed by an url
newer_output_path <- tempfile("newer_validation_result")
gtfs_url <- "https://github.com/ipeaGIT/gtfstools/raw/master/inst/extdata/spo_gtfs.zip"
validate_gtfs(gtfs_url, newer_output_path, validator_path)
list.files(newer_output_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other validation: 
\code{\link{download_validator}()}
}
\concept{validation}
