% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_route_type.R
\name{filter_by_route_type}
\alias{filter_by_route_type}
\title{Filter GTFS object by \code{route_type} (transport mode)}
\usage{
filter_by_route_type(gtfs, route_type, keep = TRUE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{route_type}{An integer vector. The \code{route_type}s used to filter the
data.}

\item{keep}{A logical. Whether the entries related to the specified
\code{route_type}s should be kept or dropped (defaults to \code{TRUE}, which keeps
the entries).}
}
\value{
The GTFS object passed to the \code{gtfs} parameter, after the filtering
process.
}
\description{
Filters a GTFS object by \code{route_type}s, keeping (or dropping) the relevant
entries in each file.
}
\section{Route types}{
Valid options are:
\itemize{
\item 0 - Tram, Streetcar, Light rail. Any light rail or street level system
within a metropolitan area.
\item 1 - Subway, Metro. Any underground rail system within a metropolitan area.
\item 2 - Rail. Used for intercity or long-distance travel.
\item 3 - Bus. Used for short- and long-distance bus routes.
\item 4 - Ferry. Used for short- and long-distance boat service.
\item 5 - Cable tram. Used for street-level rail cars where the cable runs
beneath the vehicle, e.g., cable car in San Francisco.
\item 6 - Aerial lift, suspended cable car (e.g., gondola lift, aerial tramway).
Cable transport where cabins, cars, gondolas or open chairs are suspended by
means of one or more cables.
\item 7 - Funicular. Any rail system designed for steep inclines.
\item 11 - Trolleybus. Electric buses that draw power from overhead wires using
poles.
\item 12 - Monorail. Railway in which the track consists of a single rail or a
beam.
}
}

\examples{
# read gtfs
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

object.size(gtfs)

# keeps entries related to passed route_types
smaller_gtfs <- filter_by_route_type(gtfs, route_type = 1)
object.size(smaller_gtfs)

# drops entries related to passed route_types
smaller_gtfs <- filter_by_route_type(gtfs, route_type = 1, keep = FALSE)
object.size(smaller_gtfs)

}
\seealso{
Other filtering functions: 
\code{\link{filter_by_agency_id}()},
\code{\link{filter_by_route_id}()},
\code{\link{filter_by_service_id}()},
\code{\link{filter_by_sf}()},
\code{\link{filter_by_shape_id}()},
\code{\link{filter_by_stop_id}()},
\code{\link{filter_by_time_of_day}()},
\code{\link{filter_by_trip_id}()},
\code{\link{filter_by_weekday}()}
}
\concept{filtering functions}
