% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_summary.R
\name{emis_summary}
\alias{emis_summary}
\title{Summarize emissions estimates}
\usage{
emis_summary(
  emi_list,
  by = "pollutant",
  veh_vars = "veh_type",
  segment_vars = NULL
)
}
\arguments{
\item{emi_list}{list. Emission or emission factor list.}

\item{by}{character. Emissions can be aggregated by 'time', 'vehicle', or
simply 'pollutant' (Default).}

\item{veh_vars}{character. data.frame names of 'emi_list' attributed to
vehicle characteristics. Default is 'veh_type'.}

\item{segment_vars}{character. data.frame names of 'emi_list' object
attributed to the road segments. Default is NULL.}
}
\value{
\code{data.table} with pollutants units ('g') aggregated by pollutant,
time, or vehicle type.
}
\description{
Summarize emissions estimates, aggregating emissions by pollutant, time of
the day, vehicle.
}
\examples{
\donttest{

library(gtfs2emis)
library(gtfstools)

# read GTFS
gtfs_file <- system.file("extdata/irl_dub_gtfs.zip", package = "gtfs2emis")
gtfs <- gtfstools::read_gtfs(gtfs_file)

# Keep a single trip
gtfs <- gtfstools::filter_by_trip_id(gtfs
                                     , trip_id = c('238.2.60-118-b12-1.59.I'
                                                   ,"7081.2.60-X27-b12-1.106.I"))
# Transport model
tp_model <- transport_model(gtfs_data = gtfs,
                            spatial_resolution = 100,
                            parallel = FALSE)

# fleet data
fleet_df <- read.csv(system.file("extdata/irl_dub_fleet.txt"
                                 , package = "gtfs2emis"))
# emission model
emi_list <- emission_model(tp_model = tp_model
                           , ef_model = "ef_europe_emep"
                           , fleet_data = fleet_df
                           , pollutant = c("CO2","PM10"))

# Aggregate total emissions by 'pollutant'
emis_summary(emi_list) 

# by vehicle type
emis_summary(emi_list, by = "vehicle")
             
emis_summary(emi_list
             , by = "vehicle"
             , veh_vars = c("euro"))

emis_summary(emi_list
             , by = "vehicle"
             , veh_vars = c("fuel"))

emis_summary(emi_list
             , by = "vehicle"
             , veh_vars = c("veh_type","euro","tech","fuel"))
             
# by time of the day
emis_summary(emi_list
             , by = "time"
             , segment_vars = "slope") 
}
}
\seealso{
Other emission analysis: 
\code{\link{emis_grid}()},
\code{\link{emis_to_dt}()}
}
\concept{emission analysis}
