% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eqtl_genes.R
\name{get_eqtl_genes}
\alias{get_eqtl_genes}
\title{Get Eqtl Genes}
\usage{
get_eqtl_genes(
  tissueSiteDetailIds,
  datasetId = "gtex_v8",
  page = 0,
  itemsPerPage = 250
)
}
\arguments{
\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble.
}
\description{
Retrieve eGenes (eQTL Genes).
\itemize{
\item This service returns eGenes (eQTL Genes) from the specified dataset.
\item eGenes are genes that have at least one significant cis-eQTL acting upon them.
\item Results may be filtered by tissue. By default, the service queries the latest GTEx release.
}

For each eGene, the results include the allelic fold change
(log2AllelicFoldChange), p-value (pValue), p-value threshold
(pValueThreshold), empirical p-value (empiricalPValue), and q-value
(qValue).
\itemize{
\item The log2AllelicFoldChange is the allelic fold change (in log2 scale) of the most significant eQTL.
\item The pValue is the nominal p-value of the most significant eQTL.
\item The pValueThreshold is the p-value threshold used to determine whether a cis-eQTL for this gene is significant. For more details see https://gtexportal.org/home/documentationPage#staticTextAnalysisMethods.
\item The empiricalPValue is the beta distribution-adjusted empirical p-value from FastQTL.
\item The qValues were calculated based on the empirical p-values. A false discovery rate (FDR) threshold of <= 0.05 was applied to identify genes with a significant eQTL.
}

\href{https://gtexportal.org/api/v2/redoc#tag/Static-Association-Endpoints/operation/get_eqtl_genes_api_v2_association_egene_get}{GTEx Portal API documentation}.
}
\examples{
\dontrun{
get_eqtl_genes(c("Whole_Blood", "Artery_Aorta"))
}
}
\seealso{
Other Static Association Endpoints: 
\code{\link{get_fine_mapping}()},
\code{\link{get_independent_eqtl}()},
\code{\link{get_multi_tissue_eqtls}()},
\code{\link{get_significant_single_tissue_eqtls}()},
\code{\link{get_significant_single_tissue_eqtls_by_location}()},
\code{\link{get_significant_single_tissue_ieqtls}()},
\code{\link{get_significant_single_tissue_isqtls}()},
\code{\link{get_significant_single_tissue_sqtls}()},
\code{\link{get_sqtl_genes}()}
}
\concept{Static Association Endpoints}
