% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_image_multi_rows.R
\name{gt_img_multi_rows}
\alias{gt_img_multi_rows}
\title{Add multiple local or web images into rows of a \code{gt} table}
\usage{
gt_img_multi_rows(gt_object, columns, img_source = "web", height = 30)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.}

\item{img_source}{A string, specifying either "local" or "web" as the source of the images.}

\item{height}{The absolute height (px) of the image in the table cell.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_multi_img_rows} function takes an existing \code{gt_tbl} object and
converts nested cells with filenames or urls to images into inline images. This is a wrapper
around \code{gt::text_transform()} + \code{gt::web_image()}/\code{gt::local_image()} with
the necessary boilerplate already applied.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
teams <- "https://github.com/nflverse/nflfastR-data/raw/master/teams_colors_logos.rds"
team_df <- readRDS(url(teams))

conf_table <- team_df \%>\% 
  dplyr::select(team_conf, team_division, logo = team_logo_espn) \%>\% 
  dplyr::distinct() \%>\% 
  tidyr::nest(data = logo) \%>\% 
  dplyr::rename(team_logos = data) \%>\% 
  dplyr::arrange(team_conf, team_division) \%>\% 
  gt() \%>\% 
  gt_img_multi_rows(columns = team_logos, height = 25)

}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{img-rows.png}{options: width=100\%}}
}

\section{Function ID}{

2-9
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
