% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_spanner}
\alias{tab_spanner}
\title{Add a spanner column label}
\usage{
tab_spanner(
  data,
  label,
  columns = NULL,
  spanners = NULL,
  level = NULL,
  id = label,
  gather = TRUE,
  replace = FALSE
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{label}{The text to use for the spanner column label.}

\item{columns}{The columns to be components of the spanner heading.}

\item{spanners}{The spanners that should be spanned over, should they already
be defined.}

\item{level}{An explicit level to which the spanner should be placed. If not
provided, \strong{gt} will choose the level based on the inputs provided within
\code{columns} and \code{spanners}, placing the spanner label where it will fit. The
first spanner level (right above the column labels) is \code{1}.}

\item{id}{The ID for the spanner column label. When accessing a spanner
column label through \code{\link[=cells_column_spanners]{cells_column_spanners()}} (when using \code{\link[=tab_style]{tab_style()}} or
\code{\link[=tab_footnote]{tab_footnote()}}) the \code{id} value is used as the reference (and not the
\code{label}). If an \code{id} is not explicitly provided here, it will be taken from
the \code{label} value. It is advisable to set an explicit \code{id} value if you
plan to access this cell in a later function call and the label text is
complicated (e.g., contains markup, is lengthy, or both). Finally, when
providing an \code{id} value you must ensure that it is unique across all ID
values set for column spanner labels (the function will stop if \code{id} isn't
unique).}

\item{gather}{An option to move the specified \code{columns} such that they are
unified under the spanner column label. Ordering of the moved-into-place
columns will be preserved in all cases. By default, this is set to \code{TRUE}.}

\item{replace}{Should new spanners be allowed to partially or fully replace
existing spanners? (This is a possibility if setting spanners at an already
populated \code{level}.) By default, this is set to \code{FALSE} and an error will
occur if some replacement is attempted.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Set a spanner column label by mapping it to columns already in the table.
This label is placed above one or more column labels, spanning the width of
those columns and column labels.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Use the \code{tab_spanner()} function to
effectively group several columns related to car performance under a spanner
column with the label \code{"performance"}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(
    -mfr, -trim, bdy_style,
    -drivetrain, -trsmn, -ctry_origin
  ) |>
  dplyr::slice(1:8) |>
  gt(rowname_col = "model") |>
  tab_spanner(
    label = "performance",
    columns = c(
      hp, hp_rpm, trq, trq_rpm,
      mpg_c, mpg_h
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_spanner_1.png" alt="This image of a table was generated from the first code example in the `tab_spanner()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-2
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
