% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_group.R
\name{gt_group}
\alias{gt_group}
\title{Create a \code{gt_group} container for holding multiple \strong{gt} table objects}
\usage{
gt_group(..., .list = list2(...), .use_grp_opts = FALSE)
}
\arguments{
\item{...}{One or more \strong{gt} table (\code{gt_tbl}) objects, typically generated
via the \code{\link[=gt]{gt()}} function.}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}

\item{.use_grp_opts}{Should options specified in the \code{gt_group} object be
applied to all contained \strong{gt} tables? By default this is \code{FALSE}.}
}
\value{
An object of class \code{gt_group}.
}
\description{
The \code{gt_group()} function creates a container for storage of multiple \strong{gt}
tables. This type of object allows for flexibility in printing multiple
tables in different output formats. For example, if printing multiple tables
in a paginated output environment (e.g., RTF, Word, etc.), each \strong{gt} table
can be printed independently and table separation (usually a page break)
occurs between each of those.
}
\section{Function ID}{

14-1
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table group functions: 
\code{\link{grp_add}()},
\code{\link{grp_clone}()},
\code{\link{grp_options}()},
\code{\link{grp_pull}()},
\code{\link{grp_replace}()},
\code{\link{grp_rm}()},
\code{\link{gt_split}()}
}
\concept{table group functions}
