% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_group.R
\name{grp_replace}
\alias{grp_replace}
\title{Replace one or more \strong{gt} tables in a \code{gt_group} container object}
\usage{
grp_replace(.data, ..., .list = list2(...), .which)
}
\arguments{
\item{.data}{A \code{gt_group} container object, typically generated through use
of the \code{\link[=gt_group]{gt_group()}} function along with one or more \code{gt_tbl} objects.}

\item{...}{One or more \strong{gt} table (\code{gt_tbl}) objects, typically generated
via the \code{\link[=gt]{gt()}} function.}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}

\item{.which}{Index values denoting which \code{gt_tbl} tables should be replaced
in the \code{gt_group} object.}
}
\value{
An object of class \code{gt_group}.
}
\description{
The \code{\link[=gt_group]{gt_group()}} function can be used to create a container for multiple
\strong{gt} tables. In some circumstances, you might want to replace a specific
\code{gt_tbl} object (or multiple) with a different one. This can be done with the
\code{grp_replace()} function. The important thing is that the number of \strong{gt}
tables provided must equal the number of indices for tables present in the
\code{gt_group} object.
}
\section{Function ID}{

14-6
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table group functions: 
\code{\link{grp_add}()},
\code{\link{grp_clone}()},
\code{\link{grp_options}()},
\code{\link{grp_pull}()},
\code{\link{grp_rm}()},
\code{\link{gt_group}()},
\code{\link{gt_split}()}
}
\concept{table group functions}
