% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution.R
\name{sub_small_vals}
\alias{sub_small_vals}
\title{Substitute small values in the table body}
\usage{
sub_small_vals(
  data,
  columns = everything(),
  rows = everything(),
  threshold = 0.01,
  small_pattern = if (sign == "+") "<{x}" else md("<*abs*(-{x})"),
  sign = "+"
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{threshold}{The threshold value with which values should be considered
small enough for replacement.}

\item{small_pattern}{The pattern text to be used in place of the suitably
small values in the rendered table.}

\item{sign}{The sign of the numbers to be considered in the replacement. By
default, we only consider positive values (\code{"+"}). The other option (\code{"-"})
can be used to consider only negative values.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Wherever there is numerical data that are very small in value, replacement
text may be better for explanatory purposes. The \code{sub_small_vals()} function
allows for this replacement through specification of a \code{threshold}, a
\code{small_pattern}, and the sign of the values to be considered.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the Arguments section for more information on this.
}
\section{Examples}{


Let's generate a simple, single-column tibble that contains an assortment of
values that could potentially undergo some substitution.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(num = c(10^(-4:2), 0, NA))

tbl
#> # A tibble: 9 x 1
#>        num
#>      <dbl>
#> 1   0.0001
#> 2   0.001 
#> 3   0.01  
#> 4   0.1   
#> 5   1     
#> 6  10     
#> 7 100     
#> 8   0     
#> 9  NA
}\if{html}{\out{</div>}}

The \code{tbl} contains a variety of smaller numbers and some might be small
enough to reformat with a threshold value. With \code{sub_small_vals()} we can
do just that:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_small_vals()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_small_vals_1.png" alt="This image of a table was generated from the first code example in the `sub_small_vals()` help file." style="width:100\%;">
}}

Small and negative values can also be handled but they are handled specially
by the \code{sign} parameter. Setting that to \code{"-"} will format only the small,
negative values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  dplyr::mutate(num = -num) \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_small_vals(sign = "-")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_small_vals_2.png" alt="This image of a table was generated from the second code example in the `sub_small_vals()` help file." style="width:100\%;">
}}

You don't have to settle with the default \code{threshold} value or the default
replacement pattern (in \code{small_pattern}). This can be changed and the
\code{"{x}"} in \code{small_pattern} (which uses the \code{threshold} value) can even be
omitted.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_small_vals(
    threshold = 0.0005,
    small_pattern = "smol"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_small_vals_3.png" alt="This image of a table was generated from the third code example in the `sub_small_vals()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-19
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
