% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cell_borders}
\alias{cell_borders}
\title{Helper for defining custom borders for table cells}
\usage{
cell_borders(sides = "all", color = "#000000", style = "solid", weight = px(1))
}
\arguments{
\item{sides}{The border sides to be modified. Options include \code{"left"},
\code{"right"}, \code{"top"}, and \code{"bottom"}. For all borders surrounding the
selected cells, we can use the \code{"all"} option.}

\item{color, style, weight}{The border color, style, and weight. The \code{color}
can be defined with a color name or with a hexadecimal color code. The
default \code{color} value is \code{"#000000"} (black). The \code{style} can be one of
either \code{"solid"} (the default), \code{"dashed"}, \code{"dotted"}, or \code{"hidden"}.
The \code{weight} of the border lines is to be given in pixel values (the
\code{\link[=px]{px()}} helper function is useful for this. The default value for \code{weight}
is \code{"1px"}. Borders for any defined \code{sides} can be removed by supplying
\code{NULL} to any of \code{color}, \code{style}, or \code{weight}.}
}
\value{
A list object of class \code{cell_styles}.
}
\description{
The \code{cell_borders()} helper function is to be used with the \code{\link[=tab_style]{tab_style()}}
function, which itself allows for the setting of custom styles to one or more
cells. Specifically, the call to \code{cell_borders()} should be bound to the
\code{styles} argument of \code{\link[=tab_style]{tab_style()}}. The \code{selection} argument is where we
define which borders should be modified (e.g., \code{"left"}, \code{"right"}, etc.).
With that selection, the \code{color}, \code{style}, and \code{weight} of the selected
borders can then be modified.
}
\section{Examples}{


Add horizontal border lines for all table body rows in \code{\link{exibble}} using
\code{\link[=tab_style]{tab_style()}} and \code{cell_borders()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt() \%>\%
  tab_options(row.striping.include_table_body = FALSE) \%>\%
  tab_style(
    style = cell_borders(
      sides = c("top", "bottom"),
      color = "red",
      weight = px(1.5),
      style = "solid"
    ),
    locations = cells_body(
      columns = everything(),
      rows = everything()
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cell_borders_1.png" alt="This image of a table was generated from the first code example in the `cell_borders()` help file." style="width:100\%;">
}}

Incorporate different horizontal and vertical borders at several locations.
This uses multiple \code{cell_borders()} and \code{\link[=cells_body]{cells_body()}} calls within
\code{list()}s.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt() \%>\%
  tab_style(
    style = list(
      cell_borders(
        sides = c("top", "bottom"),
        color = "#FF0000",
        weight = px(2)
      ),
      cell_borders(
        sides = c("left", "right"),
        color = "#0000FF",
        weight = px(2)
      )
    ),
    locations = list(
      cells_body(
        columns = num,
        rows = is.na(num)
      ),
      cells_body(
        columns = currency,
        rows = is.na(currency)
      )
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cell_borders_2.png" alt="This image of a table was generated from the second code example in the `cell_borders()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

7-22
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{stub}()}
}
\concept{helper functions}
