% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{px}
\alias{px}
\title{Helper for providing a numeric value as pixels value}
\usage{
px(x)
}
\arguments{
\item{x}{the numeric value to format as a string (e.g., \code{"12px"}) for
some \code{\link[=tab_options]{tab_options()}} arguments that can take values as units of
pixels (e.g., \code{table.font.size}).}
}
\value{
A character vector with a single value in pixel units.
}
\description{
For certain parameters, a length value is required. Examples include the
setting of font sizes (e.g., in \code{\link[=cell_text]{cell_text()}}) and thicknesses of lines
(e.g., in \code{\link[=cell_borders]{cell_borders()}}). Setting a length in pixels with \code{px()} allows
for an absolute definition of size as opposed to the analogous helper
function \code{\link[=pct]{pct()}}.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. Use the \code{px()} helper to define the
font size for the column labels.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt() \%>\%
  tab_style(
    style = cell_text(size = px(20)),
    locations = cells_column_labels()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_px_1.png" alt="This image of a table was generated from the first code example in the `px()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

7-3
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{random_id}()}
}
\concept{helper functions}
