% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_date}
\alias{fmt_date}
\title{Format values as dates}
\usage{
fmt_date(data, columns, rows = everything(), date_style = 2, pattern = "{x}")
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{date_style}{The date style to use. Supply a number (from \code{1} to \code{14})
that corresponds to the preferred date style, or, provide a named date
style (\code{"wday_month_day_year"}, \code{"m_day_year"}, \code{"year.mn.day"}, etc.). Use
\code{\link[=info_date_style]{info_date_style()}} to see the different numbered and named date presets.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Format input values to time values using one of fourteen presets. Input can
be in the form of \code{POSIXt} (i.e., date-times), the \code{Date} type, or
\code{character} (must be in the ISO 8601 form of \verb{YYYY-MM-DD HH:MM:SS} or
\code{YYYY-MM-DD}).

Once the appropriate data cells are targeted with \code{columns} (and, optionally,
\code{rows}), we can simply apply a preset date style to format the dates. The
following date styles are available for use (all using the input date of
\code{2000-02-29} in the example output dates):
\enumerate{
\item \code{"iso"}: \code{2000-02-29}
\item \code{"wday_month_day_year"}: \verb{Tuesday, February 29, 2000}
\item \code{"wd_m_day_year"}: \verb{Tue, Feb 29, 2000}
\item \code{"wday_day_month_year"}: \verb{Tuesday 29 February 2000}
\item \code{"month_day_year"}: \verb{February 29, 2000}
\item \code{"m_day_year"}: \verb{Feb 29, 2000}
\item \code{"day_m_year"}: \verb{29 Feb 2000}
\item \code{"day_month_year"}: \verb{29 February 2000}
\item \code{"day_month"}: \verb{29 February}
\item \code{"year"}: \code{2000}
\item \code{"month"}: \code{February}
\item \code{"day"}: \code{29}
\item \code{"year.mn.day"}: \code{2000/02/29}
\item \code{"y.mn.day"}: \code{00/02/29}
}

We can use the \code{\link[=info_date_style]{info_date_style()}} function for a useful reference on all of
the possible inputs to \code{date_style}.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the \emph{Arguments} section for more information on this.
}
\section{Figures}{

\if{html}{\figure{man_fmt_date_1.png}{options: width=100\%}}

\if{html}{\figure{man_fmt_date_2.png}{options: width=100\%}}
}

\section{Function ID}{

3-8
}

\examples{
# Use `exibble` to create a gt table;
# keep only the `date` and `time` columns;
# format the `date` column to have
# dates formatted as `month_day_year`
# (date style `5`)
tab_1 <-
  exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_date(
    columns = date,
    date_style = 5
  )

# Use `exibble` to create a gt table;
# keep only the `date` and `time` columns;
# format the `date` column to have mixed
# date formats (dates after April will
# be different than the others)
tab_2 <-
  exibble \%>\%
  dplyr::select(date, time) \%>\%
  gt() \%>\%
  fmt_date(
    columns = date,
    rows =
      as.Date(date) > as.Date("2015-04-01"),
    date_style = "m_day_year"
  ) \%>\%
  fmt_date(
    columns = date,
    rows =
      as.Date(date) <= as.Date("2015-04-01"),
    date_style = "day_m_year"
  )

}
\seealso{
Other Format Data: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_missing}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{text_transform}()}
}
\concept{Format Data}
