% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_body}
\alias{cells_body}
\title{Location helper for targeting data cells in the table body}
\usage{
cells_body(columns = TRUE, rows = TRUE)
}
\arguments{
\item{columns}{The names of the columns that are to be targeted.}

\item{rows}{The names of the rows that are to be targeted.}
}
\value{
A list object with the classes \code{cells_body} and \code{location_cells}.
}
\description{
The \code{cells_body()} function is used to target the data cells in the table
body. The function can be used to apply a footnote with \code{\link[=tab_footnote]{tab_footnote()}}, to
add custom styling with \code{\link[=tab_style]{tab_style()}}, or the transform the targeted cells
with \code{\link[=text_transform]{text_transform()}}. The function is expressly used in each of those
functions' \code{locations} argument.
}
\details{
When using any of the location helper functions with an appropriate function
that has a \code{locations} argument, multiple locations can be targeted by
enclosing several \verb{cells_*()} helper functions in a \code{list()}. The following
helper functions can be used to target cells (roughly in order from the top
to the bottom of a table):
\itemize{
\item \code{\link[=cells_title]{cells_title()}}: targets the table title or the table subtitle
depending on the value given to the \code{groups} argument (\code{"title"} or
\code{"subtitle"}).
\item \code{\link[=cells_stubhead]{cells_stubhead()}}: targets the stubhead location, a cell of which is
only available when there is a stub; a label in that location can be created
by using the \code{\link[=tab_stubhead]{tab_stubhead()}} function.
\item \code{\link[=cells_column_spanners]{cells_column_spanners()}}: targets the spanner column labels, which
appear above the column labels.
\item \code{\link[=cells_column_labels]{cells_column_labels()}}: targets the column labels.
\item \code{\link[=cells_row_groups]{cells_row_groups()}}: targets the row group labels in any available row
groups using the \code{groups} argument.
\item \code{\link[=cells_stub]{cells_stub()}}: targets row labels in the table stub using the \code{rows}
argument.
\item \code{\link[=cells_body]{cells_body()}}: targets data cells in the table body using
intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_summary]{cells_summary()}}: targets summary cells in the table body using the
\code{groups} argument and intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_grand_summary]{cells_grand_summary()}}: targets cells of the table's grand summary
using intersections of \code{columns} and \code{rows}
}
}
\section{Figures}{

\if{html}{\figure{man_cells_body_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-11
}

\examples{
# Use `gtcars` to create a gt table; add
# a footnote that targets a single data cell
# with `tab_footnote()`, using `cells_body()`
# in `locations` (`rows = hp == max(hp)` will
# target a single row in the `hp` column)
tab_1 <-
  gtcars \%>\%
  dplyr::filter(ctry_origin == "United Kingdom") \%>\%
  dplyr::select(mfr, model, year, hp) \%>\%
  gt() \%>\%
  tab_footnote(
    footnote = "Highest horsepower.",
    locations = cells_body(
      columns = vars(hp),
      rows = hp == max(hp))
  ) \%>\%
  opt_footnote_marks(marks = c("*", "+"))

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{escape_latex}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
