% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\docType{data}
\name{saar}
\alias{saar}
\title{Global SA lookup file}
\description{
This dataset is not intended for users, but rather for internal use
within the \code{gsw} package. The dataset stores the 1.4M lookup
table defined in the 8.3M file \code{src/gsw_saar_data.c} in the C
library. (The .c file exceeds CRAN limitations on size.)
}
\details{
The data are designed to replace C elements defined as below
in \code{src/gsw_saar_data.c}:
\preformatted{
    static int	gsw_nx=91, gsw_ny=45, gsw_nz=45;
    static double	longs_ref[91];
    static double	lats_ref[45];
    static double	p_ref[45];
    static double	ndepth_ref[4095];
    static double	saar_ref[184275];
    static double	delta_sa_ref[184275];
}

R storage is in a list named \code{saar}, with elements named
as in the C code, i.e. \code{gsw_nx} etc.

C storage for these variables is allocated as needed,
and the data are inserted, when \code{gsw} is launched.
Thus, the existing C library code "knows" about the data
as local storage, which keeps alterations to the C library to
a minimum.

The \code{saar} dataset was created by the following R code. The
netcdf file used in this code comes from the GSW-Fortran
repository (at commit \code{baa0c09ffc7ed1f74972a1a2902d8754caa5b4cb})
and its md5 value is \code{dacb3f981e8e710ac2e83477701b3905}.
\preformatted{
  library(ncdf4)
  nc <- nc_open("~/git/GSW-Fortran/test/gsw_data_v3_0.nc")
  ## Use as.vector() since these will all get handed into C, which does not understand matrices.
  p_ref <- as.vector(ncvar_get(nc, "p_ref"))
  lats_ref <- as.vector(ncvar_get(nc, "lats_ref"))
  longs_ref <- as.vector(ncvar_get(nc, "longs_ref"))
  ndepth_ref <- as.vector(ncvar_get(nc, "ndepth_ref"))
  ndepth_ref[!is.finite(ndepth_ref)] <- -9e99
  saar_ref <- as.vector(ncvar_get(nc, "SAAR_ref"))
  saar_ref[!is.finite(saar_ref)] <- -9e99
  delta_sa_ref <- as.vector(ncvar_get(nc, "deltaSA_ref"))
  delta_sa_ref[!is.finite(delta_sa_ref)] <- -9e99
  saar <- list(gsw_nx=gsw_nx, gsw_ny=gsw_ny, gsw_nz=gsw_nz,
               longs_ref=longs_ref, lats_ref=lats_ref, p_ref=p_ref, ndepth_ref=ndepth_ref,
               saar_ref=saar_ref, delta_sa_ref=delta_sa_ref)
  save(saar, file="saar.rda")
  tools::resaveRdaFiles("saar.rda")
  nc_close(nc)
}
}
