% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Fdelta}
\alias{gsw_Fdelta}
\title{Ratio of Absolute to Preformed Salinity, minus 1}
\usage{
gsw_Fdelta(p, longitude, latitude)
}
\arguments{
\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
(S/SStar)-1 [ unitless ]
}
\description{
Ratio of Absolute to Preformed Salinity, minus 1
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
p <- c(         10,   50,  125,  250,  600, 1000)
latitude <- c(   4,    4,    4,    4,    4,    4)
longitude <- c(188,  188,  188,  188,  188,  188)
r <- gsw_Fdelta(p, longitude, latitude)
expect_equal(r/1e-3, c(0.006472309923452, 0.010352848168433, 0.025541937543450,
                     0.104348729347986, 0.218678084205081, 0.365415366571266))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Fdelta.html}
}
