% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{read_intensities}
\alias{read_intensities}
\title{Read multiple idat files.}
\usage{
read_intensities(files, dict = NULL, cnames = NULL, pos = NULL,
  beads = FALSE, sd = FALSE)
}
\arguments{
\item{files}{A vector of filenames.
Two consecutive lines per sample.
The order (e.g. green,red) must be consistent for all samples.}

\item{dict}{A dataframe with columns "idatID" and "name".}

\item{cnames}{Vector of characters as column names.}

\item{pos}{Position object with at least the column "name". Is used to filter out SNPs where the position is not known.}

\item{beads}{Logical, if beads should be read in.}

\item{sd}{Logical, if standard deviation should be read in.}
}
\value{
An object containing the identities from the idat files.
}
\description{
This function is a wrapper to for illuminaio's \code{readIDAT} function.
A dictionary will translate the standard IDs from the IDAT file into SNP names.
A position file, will filter out all SNPs where the position is unknown.
This might save a lot of memory and allow to read in more samples at once.
This function is provided to simplify the use of the example data.
For data produced with other arrays use respective functions available in CRAN or Bioconductor.
}
\examples{
if(require(brassicaData)){
files <- list.files(system.file("extdata", package = "brassicaData"),
full.names = TRUE, pattern = "idat")
samples <- read_sample_sheets(files = list.files(system.file("extdata",
package = "brassicaData"), full.names = TRUE, pattern = "csv"))
column_names <- sapply(strsplit(files,split="/"), FUN=function(x) x[length(x)])
data("dictionary", package = "brassicaData", envir = environment())
data("chrPos", package = "brassicaData", envir = environment())
raw_data <- read_intensities(files = files, dict = dictionary,
cnames = column_names, pos = chrPos)
}
}

