% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{deviance.gsl_nls}
\alias{deviance.gsl_nls}
\title{Model deviance}
\usage{
\method{deviance}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric deviance value similar to \code{\link[stats]{deviance}}
}
\description{
Returns the deviance of a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
deviance(obj)
}
\seealso{
\code{\link[stats]{deviance}}
}
