% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{gr_buffer_geo}
\alias{gr_buffer_geo}
\title{Quasi-geographic buffering}
\usage{
gr_buffer_geo(g, bufsize)
}
\arguments{
\item{g}{\code{sf} or \code{sfg} object with known coordinate system.}

\item{bufsize}{Numeric value of a buffer distance, in meters.}
}
\value{
\code{sf} or \code{sfg} object, buffered to \code{bufsize} and projected into geographic coordinates (WGS84).
}
\description{
Generate the buffer of spatial object in geographic coordinates. The function transforms the object into Azimuthal equidistant projection, then buffers it by the specified radius and then reprojects into geographical coordinate system (WGS84)
}
\examples{
if (require("sf")) {

  library(grwat)
  library(ggplot2)
  path = system.file("extdata", "spas-zagorye.gpkg", package = "grwat")
  basin = sf::st_read(path, layer = 'basin') # read basin region

  basin_buffer = gr_buffer_geo(basin, 25000)

  ggplot() +
    geom_sf(data = basin_buffer, fill = 'orangered', color = 'black') +
    geom_sf(data = basin, fill = 'steelblue', color = 'black')

}
}
