% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_effsize_ci.R
\name{lm_effsize_standardizer}
\alias{lm_effsize_standardizer}
\title{Standardize a dataframe with effect sizes for \code{aov}, \code{lm}, \code{aovlist},
etc. objects.}
\usage{
lm_effsize_standardizer(
  object,
  effsize = "eta",
  partial = TRUE,
  conf.level = 0.95,
  nboot = 500,
  method = c("dist", "quantile")
)
}
\arguments{
\item{object}{The linear model object (can be of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}).}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}.}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{conf.level}{Numeric specifying Level of confidence for the confidence
interval (Default: \code{0.95}).}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared (Default: \code{500}).}

\item{method}{Character vector, indicating if confidence intervals should be
based on bootstrap standard error, multiplied by the value of the
quantile function of the t-distribution (default), or on sample
quantiles of the bootstrapped values. See 'Details' in \code{boot_ci()}.
May be abbreviated.}
}
\description{
The difference between \code{lm_effsize_ci} and
\code{lm_effsize_standardizer} is that the former has more opinionated column
naming, while the latter doesn't. The latter can thus be more helpful in
writing a wrapper around this function.
}
\examples{
set.seed(123)
groupedstats::lm_effsize_standardizer(
  object = stats::lm(formula = brainwt ~ vore, data = ggplot2::msleep),
  effsize = "eta",
  partial = FALSE,
  conf.level = 0.99,
  nboot = 20
)
}
