% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nameIt.R
\name{nameIt}
\alias{nameIt}
\title{'Groq': Create a Function or Variable Name}
\usage{
nameIt(code = NULL, namingConvention = "camelCase", ...)
}
\arguments{
\item{code}{The code for which to give a variable name to its result.
If not provided, it will use what's copied on the clipboard.}

\item{namingConvention}{Defaults to "camelCase".}

\item{...}{Following arguments can be set manually or in .Renviron:
\code{GROQ_API_KEY}is the 'Groq API' key.
\code{model} Model choice. Default is mistral-7b-instruct.
\code{systemRole} System role; Default is: "You are a helpful assistant
with extensive knowledge of R programming."
\code{maxTokens} The maximum integer of completion tokens returned.
\code{temperature} The amount of randomness in the response,
valued between 0 inclusive and 2 exclusive. Higher values are more
random, and lower values are more deterministic.
\code{top_p} Nucleus sampling threshold, valued between 0 and 1.
\code{proxy} Default value is NULL.}
}
\value{
A character value with the response generated by 'Groq'.
}
\description{
'Groq': Create a Function or Variable Name
}
\examples{
\dontrun{
cat(nameIt("sapply(1:10, function(i) i ** 2)"))
}

}
