% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll_regression_forest.R
\name{ll_regression_forest}
\alias{ll_regression_forest}
\title{Local linear forest}
\usage{
ll_regression_forest(
  X,
  Y,
  enable.ll.split = FALSE,
  ll.split.weight.penalty = FALSE,
  ll.split.lambda = 0.1,
  ll.split.variables = NULL,
  ll.split.cutoff = NULL,
  num.trees = 2000,
  clusters = NULL,
  equalize.cluster.weights = FALSE,
  sample.fraction = 0.5,
  mtry = min(ceiling(sqrt(ncol(X)) + 20), ncol(X)),
  min.node.size = 5,
  honesty = TRUE,
  honesty.fraction = 0.5,
  honesty.prune.leaves = TRUE,
  alpha = 0.05,
  imbalance.penalty = 0,
  ci.group.size = 2,
  tune.parameters = "none",
  tune.num.trees = 50,
  tune.num.reps = 100,
  tune.num.draws = 1000,
  num.threads = NULL,
  seed = runif(1, 0, .Machine$integer.max)
)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{enable.ll.split}{(experimental) Optional choice to make forest splits based on ridge residuals as opposed to
standard CART splits. Defaults to FALSE.}

\item{ll.split.weight.penalty}{If using local linear splits, user can specify whether or not to use a
covariance ridge penalty, analogously to the prediction case. Defaults to FALSE.}

\item{ll.split.lambda}{Ridge penalty for splitting. Defaults to 0.1.}

\item{ll.split.variables}{Linear correction variables for splitting. Defaults to all variables.}

\item{ll.split.cutoff}{Enables the option to use regression coefficients from the full dataset for LL splitting
once leaves get sufficiently small. Leaf size after which we use the overall beta.
Defaults to the square root of the number of samples. If desired, users can enforce no
regulation (i.e., using the leaf betas at each step) by setting this parameter to zero.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions. Default is 2000.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.
Default is NULL (ignored).}

\item{equalize.cluster.weights}{If FALSE, each unit is given the same weight (so that bigger
clusters get more weight). If TRUE, each cluster is given equal weight in the forest. In this case,
during training, each tree uses the same number of observations from each drawn cluster: If the
smallest cluster has K units, then when we sample a cluster during training, we only give a random
K elements of the cluster to the tree-growing procedure. When estimating average treatment effects,
each observation is given weight 1/cluster size, so that the total weight of each cluster is the
same. Default is FALSE.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction. Default is 0.5.}

\item{mtry}{Number of variables tried for each split. Default is
\eqn{\sqrt p + 20} where p is the number of variables.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.
Default is 5.}

\item{honesty}{Whether to use honest splitting (i.e., sub-sample splitting). Default is TRUE.
For a detailed description of honesty, honesty.fraction, honesty.prune.leaves, and recommendations for
parameter tuning, see the grf algorithm reference.}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds
to set J1 in the notation of the paper. Default is 0.5 (i.e. half of the data is used for
determining splits).}

\item{honesty.prune.leaves}{If TRUE, prunes the estimation sample tree such that no leaves
are empty. If FALSE, keep the same tree as determined in the splits sample (if an empty leave is encountered, that
tree is skipped and does not contribute to the estimate). Setting this to FALSE may improve performance on
small/marginally powered data, but requires more trees (note: tuning does not adjust the number of trees).
Only applies if honesty is enabled. Default is TRUE.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split. Default is 0.05.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized. Default is 0.}

\item{ci.group.size}{The forest will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2. Default is 1.}

\item{tune.parameters}{If true, NULL parameters are tuned by cross-validation; if FALSE
NULL parameters are set to defaults. Default is FALSE. Currently, local linear tuning
is based on regression forest fit, and is only supported for `enable.ll.split = FALSE`.}

\item{tune.num.trees}{The number of trees in each 'mini forest' used to fit the tuning model. Default is 10.}

\item{tune.num.reps}{The number of forests used to fit the tuning model. Default is 100.}

\item{tune.num.draws}{The number of random parameter values considered when using the model
to select the optimal parameters. Default is 1000.}

\item{num.threads}{Number of threads used in training. By default, the number of threads is set
to the maximum hardware concurrency.}

\item{seed}{The seed of the C++ random number generator.}
}
\value{
A trained local linear forest object.
}
\description{
Trains a local linear forest that can be used to estimate
the conditional mean function mu(x) = E[Y | X = x]
}
\examples{
\donttest{
# Train a standard regression forest.
n <- 50
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
forest <- ll_regression_forest(X, Y)
}

}
