% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determination.R
\name{determination}
\alias{determination}
\alias{determ}
\title{Coefficients of determination}
\usage{
determination(xreg, bruteforce = TRUE, ...)

determ(object, ...)
}
\arguments{
\item{xreg}{Data frame or a matrix, containing the exogenous variables.}

\item{bruteforce}{If \code{TRUE}, then all the variables will be used
for the regression construction (sink regression). If the number of
observations is smaller than the number of series, the function will
use \link[greybox]{stepwise} function and select only meaningful
variables. So the reported values will be based on stepwise regressions
for each variable.}

\item{...}{Other values passed to cor function.}

\item{object}{The object, for which to calculate the coefficients of
determination.}
}
\value{
Function returns the vector of determination coefficients.
}
\description{
Function produces coefficients of determination for the provided data
}
\details{
The function calculates coefficients of determination (aka R^2)
between all the provided variables. The higher the coefficient for a
variable is, the higher the potential multicollinearity effect in the
model with the variable will be. Coefficients of determination are
connected directly to Variance Inflation Factor (VIF): VIF = 1 / (1 -
determination). Arguably it is easier to interpret, because it is
restricted with (0, 1) bounds. The multicollinearity can be
considered as serious, when determination > 0.9 (which corresponds
to VIF > 10).

The method \code{determ} can be applied to wide variety of classes,
including \code{lm}, \code{glm} and \code{alm}.

See details in the vignette "Marketing analytics with greybox":
\code{vignette("maUsingGreybox","greybox")}
}
\examples{

### Simple example
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("x1","x2","x3","Noise")
determination(xreg)

}
\seealso{
\link[stats]{cor}, \link[greybox]{mcor}, \link[greybox]{stepwise}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
