% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nparam}
\alias{nparam}
\title{Number of parameters in the model}
\usage{
nparam(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some other parameters passed to the method.}
}
\value{
This function returns a numeric value.
}
\description{
This function returns the number of estimated parameters in the model
}
\details{
This is a very basic and a simple function which does what it says:
extracts number of parameters in the estimated model.
}
\examples{

### Simple example
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
ourModel <- lm(y~.,data=as.data.frame(xreg))

nparam(ourModel)

}
\seealso{
\link[stats]{nobs}, \link[stats]{logLik}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
