% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_HRLambda.R
\name{HRLambda}
\alias{HRLambda}
\alias{HRLambda.HRMBG}
\title{Parameter matrix of a Huesler-Reiss distribution}
\usage{
HRLambda(obj, ...)

\method{HRLambda}{HRMBG}(obj, ...)
}
\arguments{
\item{obj}{is an object of class \code{HRMBG} with non-zero edge weights.}

\item{...}{additional arguments}
}
\value{
A symmetric matrix whose entry lambda_{ij} is the sum of the edge weights on the shortest
path between node i and node j.
}
\description{
It creates the parameter matrix Lambda of the limiting max-stable Huesler-Reiss distribution which is an attractor of
a graphical model with respect to some block graph and whose distribution is composed cliquewise from
Huesler-Reiss distributions. See Vignette "Introduction" too.
The entry lambda_{ij} is the sum of the edge weights on the shortest
 path between node i and node j in the block graph.
The matrix Lambda can be used to generate observations from that max-stable Huesler-Reiss distribution.
}
\examples{
g<- graph(c(1,3,1,2,2,3,
            3,4,4,5,5,3,
            3,7,3,6,6,7), directed=FALSE)
g<- set.vertex.attribute(g, "name", V(g), c("a", "b", "c", "d", "e", "f", "g"))
# all deltas are squares already
C1<- c(0.2, 0.8, 0.6)   # d_13^2, d_12^2, d_23^2
C2<- c(0.3, 0.5, 0.1)   # d_34^2, d_45^2, d_35^2
C3<- c(0.4, 0.05, 0.25) # d_37^2, d_36^2, d_67^2
hrmbgobj<- HRMBG(g)
hrmbgobj<- setParams(hrmbgobj, c(C1, C2, C3))
hrmlam<- HRLambda(hrmbgobj)
}
