% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raster-class.R, R/SpatRaster-class.R,
%   R/array-class.R, R/detectFronts-methods.R, R/grec-main.R, R/list-class.R,
%   R/matrix-class.R
\name{detectFronts.RasterLayer}
\alias{detectFronts.RasterLayer}
\alias{detectFronts.SpatRaster}
\alias{detectFronts.array}
\alias{detectFronts.default}
\alias{detectFronts}
\alias{detectFronts.list}
\alias{detectFronts.matrix}
\title{Apply gradient-based methodologies to environmental data}
\usage{
\method{detectFronts}{RasterLayer}(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)

\method{detectFronts}{SpatRaster}(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)

\method{detectFronts}{array}(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)

\method{detectFronts}{default}(
  x,
  method = "BelkinOReilly2009",
  intermediate = FALSE,
  ConvolNormalization = FALSE,
  ...
)

detectFronts(
  x,
  method = "BelkinOReilly2009",
  intermediate = FALSE,
  ConvolNormalization = FALSE,
  ...
)

\method{detectFronts}{list}(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)

\method{detectFronts}{matrix}(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)
}
\arguments{
\item{x}{Main input of class \code{matrix}, \code{array}, XYZ \code{list},
\code{SpatRaster} or \code{RasterLayer}*. See 'Details.'}

\item{method}{\code{character} string indicating the method that will be used.
For the available methods, see 'Details'.}

\item{intermediate}{\code{logical} indicating whether to get the intermediate
matrices (\code{TRUE}) or just the final one (\code{FALSE}).}

\item{...}{Extra arguments that will depend on the selected method. See
Details.}

\item{ConvolNormalization}{\code{logical} indicating if convolutions will
perform a previous normalization (\code{FALSE} by default). See Details.}
}
\value{
The output will preserve the input class (\code{matrix}, \code{array},
\code{list} or \code{RasterLayer}).
}
\description{
This function takes a numeric \code{matrix}, \code{array},
XYZ-\code{list}, \code{SpatRaster} or \code{RasterLayer}* and allows
the users to apply methodologies based on gradient-searching.
}
\details{
\strong{grec} works in joint to \strong{imagine} package in order to
perform and apply image processing algorithms for the identification of
oceanic fronts. \strong{imagine} provides the basic algorithms developed in a
efficient way (using C++ tools). On the other hand, \strong{grec} is in
charge of managing the use of this coding tools in the context of oceanic
gradient recognition and dealing with the developing of input/output methods.
In that regard, the available methods that \strong{grec} offer will depend
the versions of installed \strong{grec-imagine}.

\code{RasterLayer}*: As the news of \strong{raster} package will no longer
available, \code{RasterLayer} will not longer supported in future versions of
\code{grec}. On the other hand, methods for \code{SpatRaster} will started to
be avavilable since v.1.5.0.

Until the current version, \code{grec} performs two methods:
\enumerate{
\item \code{BelkinOReilly2009} (default): Based on Belkin & O'Reilly (2009)
article, it uses a Contextual Median Filter (CMF) for smoothing the original
data before the applying of Sobel filters.
\item \code{median_filter}: it uses a typical median filter (MF) for
smoothing the original data. It also allows the user to change the window
size for median filter (3 as default).
}

\code{x} could be given as a single numeric \code{matrix} from an
environmental map. Othersiwe it also can be set as a three-dimension XYZ
\code{list}: 'x' (a vector of longitudes), 'y' (vector of latitudes) and 'z'
as a matrix of dimensions \code{length(x$x)}x\code{xlength(x$y)}. You can
also specify \code{x} as an \code{array}, \code{SpatRaster} or
\code{RasterLayer}* object. If \code{x} is an \code{array}, it must be of 3
dimensions: lon, lat and time. It is not required to specify the
\code{dimnames}. The output will preserve all the attributes of input.

\code{...} allows the (advanced) users to modify some aspects of filter
application. Depending on the selected methodology, some parameters can be
modified:

\describe{
\item{\strong{times}}{\code{numeric}. How many times do you want to apply
the filtering method?}
\item{\strong{kernelValues}}{\code{numeric}. Vector with which are going to
be used in convolution to identify Vertical and Horizontal gradients.}
\item{\strong{radius}}{\code{numeric}. If median filter method was selected,
it allows to change the window size of the filter.}
}

Normalization is a common practice in convolution in order to ensure that
outputs are weighted within original range of values. It is achieved dividing
outputs of convolution by \code{sum(abs(kernel))}. It is hardly recomended to
use normalization in order to have always coherent values in regards of the
original inputs; however, it is deactivated by default and user can swith it
on by setting \code{ConvolNormalization = TRUE}.

Finally, Belkin & O'Reilly work proposed a log transformation after the
gradient calculation. This step has NOT been considered as default
in the function due to its application is focused on Chlorophyll values,
so the user must decide to apply it or not manually before.
}
\examples{
data(sst)
exampleSSTData <- list(x = sst$longitude,
                       y = sst$latitude,
                       z = sst$sst[,,1])

data(chl)
exampleChlData <- list(x = chl$longitude,
                       y = chl$latitude,
                       z = chl$chlorophyll[,,1])

# Simple application (over a XYZ list)
out_sst <- detectFronts(x = exampleSSTData)
out_chl <- detectFronts(x = exampleChlData)

# External transformation for chl data
out_chl$z <- log10(out_chl$z)

par(mfrow = c(2, 2), mar = rep(0, 4), oma = rep(0, 4))

image(exampleSSTData, col = colPalette, axes = FALSE)
mtext(text = "Original SST", side = 3, line = -2, adj = 0.99, cex = 1.2)

image(out_sst, col = colPalette, axes = FALSE)
mtext(text = "SST gradient", side = 3, line = -2, adj = 0.99, cex = 1.2)

image(exampleChlData, col = colPalette, axes = FALSE)
mtext(text = "Original Chlorophyll", side = 3, line = -2, adj = 0.99, cex = 1.2)

image(out_chl, col = colPalette, axes = FALSE)
mtext(text = "Chlorophyll gradient\n(log scale)", side = 3, line = -4, adj = 0.99,
      cex = 1.2)
}
\references{
Belkin, I. M., & O'Reilly, J. E. (2009). An algorithm for oceanic
front detection in chlorophyll and SST satellite imagery. Journal of Marine
Systems, 78(3), 319-326 (\doi{10.1016/j.jmarsys.2008.11.018}).
}
