% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_gran.R
\name{search_gran}
\alias{search_gran}
\title{Search for granularities}
\usage{
search_gran(
  .data,
  lowest_unit = NULL,
  highest_unit = NULL,
  hierarchy_tbl = NULL,
  filter_in = NULL,
  filter_out = NULL,
  ...
)
}
\arguments{
\item{.data}{A tsibble object.}

\item{lowest_unit}{Typically set as the finest unit required for analysis. For "regular" tsibble, lgran is the interval of the tsibble. It needs to be specified for "irregular" time intervals.For non-temporal data, default is the first unit specified in the hierarchy table.}

\item{highest_unit}{Typically set as the most coarse unit required for analysis.For temporal data, default is "year" and for non-temporal data, default is set as the last unit specified in the hierarchy table.}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and their relationships.}

\item{filter_in}{Choices of temporal units to be kept.}

\item{filter_out}{Choices of temporal units to be discarded.}

\item{...}{Other arguments to be passed.}
}
\value{
Set of possible granularities.
}
\description{
Get set of possible granularities that can be considered exhaustively depending on the frequency of the data.
}
\examples{
library(tsibbledata)
vic_elec \%>\% search_gran(lowest_unit = "hour", highest_unit = "month")
}
