% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student_repayment.R
\name{student_repayment}
\alias{student_repayment}
\title{HELP / HECS repayment amounts}
\source{
\url{https://www.ato.gov.au/Rates/HELP,-TSL-and-SFSS-repayment-thresholds-and-rates/?page=2#HELP_repayment_thresholds_and_rates_2013_14} and
\url{https://github.com/HughParsonage/library/blob/master/ed17-0138_-_he_-_glossy_budget_report_acc.pdf}
}
\usage{
student_repayment(repayment_income, fy.year, debt)
}
\arguments{
\item{repayment_income}{The repayment income of the individual, equal to 
{Taxable Income} +
{Total net investment loss (incl Net rental loss)} +
 {reportable fringe benefits amounts} +
 {Reportable super contributions} +
 {exempt foreign income}}

\item{fy.year}{The financial year \code{repayment_income} was earned.}

\item{debt}{The amount of student debt held.}
}
\value{
The repayment amount.
}
\description{
HELP / HECS repayment amounts
}
\details{
The student repayments for \code{fy.year = '2018-19'} assume the measures in Budget 2017 will pass.
}
\examples{
student_repayment(50e3, "2013-14", debt = 10e3) 
# 0 since below the threshold

student_repayment(60e3, "2013-14", debt = 10e3)
# above the threshold

student_repayment(60e3, "2013-14", debt = 0)
# above the threshold, but no debt
}
\author{
Ittima Cherastidtham and Hugh Parsonage
}
