% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-estimates.R
\name{smooth_estimates}
\alias{smooth_estimates}
\alias{smooth_estimates.gam}
\title{Evaluate smooths at covariate values}
\usage{
smooth_estimates(object, ...)

\method{smooth_estimates}{gam}(
  object,
  smooth = NULL,
  n = 100,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  unnest = TRUE,
  partial_match = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"gam"} or \code{"gamm"}.}

\item{...}{arguments passed to other methods.}

\item{smooth}{character; a single smooth to evaluate.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{data}{a data frame of covariate values at which to evaluate the
smooth.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}

\item{unnest}{logical; unnest the smooth objects?}

\item{partial_match}{logical; in the case of character \code{select}, should
\code{select} match partially against \code{smooths}? If \code{partial_match = TRUE},
\code{select} must only be a single string, a character vector of length 1.}
}
\value{
A data frame (tibble), which is of class \code{"smooth_estimates"}.
}
\description{
Evaluate a smooth at a grid of evenly spaced value over the range of the
covariate associated with the smooth. Alternatively, a set of points at which
the smooth should be evaluated can be supplied. \code{smooth_estimates()} is a new
implementation of \code{\link[=evaluate_smooth]{evaluate_smooth()}}, and should be used instead of that
other function.
}
\examples{
load_mgcv()
\dontshow{op <- options(cli.unicode = FALSE, digits = 6)}
dat <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 2)
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## evaluate all smooths
smooth_estimates(m1)

## or selected smooths
smooth_estimates(m1, smooth = c("s(x0)", "s(x1)"))
\dontshow{options(op)}
}
