% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month-scale.R
\name{scale_x_grates_month}
\alias{scale_x_grates_month}
\title{Month scale}
\usage{
scale_x_grates_month(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  format = "\%Y-\%m-\%d",
  bounds_format = "\%Y-\%b",
  sep = "to",
  n
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_month>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{format}{Format to use if "Date" scales are required.

If NULL then labels are centralised and of the form "lower category bound to
upper category bound".

If not NULL then the value is used by \code{format.Date()} and can be any input
acceptable by that function (defaults to "\%Y-\%m-\%d).}

\item{bounds_format}{Format to use for grouped date labels. Only used if \code{format} is NULL.}

\item{sep}{\verb{[character]}

Separator to use for grouped date labels.}

\item{n}{\verb{[integer]}

Number of months used for the original grouping.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for a month vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) withAutoprint(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist

# calculate the bimonthly number of cases
x <- as_month(linelist$date_of_infection, n = 2)
(dat <- aggregate(list(cases = x), by = list(group = x), FUN = length))

# by default lower date bounds are used for the x axis
(bimonth_plot <-
    ggplot2::ggplot(dat, ggplot2::aes(group, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw() +
    ggplot2::theme(
        axis.text.x = ggplot2::element_text(
            angle = 45,
            hjust = 1
        )
    ) +
    ggplot2::xlab(""))

# To obtain centred labels you must explicitly set the format to NULL
# in the scale:
bimonth_plot + scale_x_grates_month(format = NULL, n = 2)
\dontshow{\}) # examplesIf}
}
