% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoweek.R
\name{as_isoweek}
\alias{as_isoweek}
\alias{as_isoweek.default}
\alias{as_isoweek.Date}
\alias{as_isoweek.POSIXt}
\alias{as_isoweek.character}
\alias{as_isoweek.factor}
\title{Coerce to a isoweek object}
\usage{
as_isoweek(x, ...)

\method{as_isoweek}{default}(x, ...)

\method{as_isoweek}{Date}(x, ...)

\method{as_isoweek}{POSIXt}(x, ...)

\method{as_isoweek}{character}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)

\method{as_isoweek}{factor}(x, format, tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"), ...)
}
\arguments{
\item{x}{\R object.}

\item{...}{Other values passed to as.Date().}

\item{format}{\verb{[character]}

Passed to as.Date() unless \code{format = "yearweek"} in which case input is
assumed to be in the form "YYYY-Wxx".

If not specified, it will try tryFormats one by one on the first non-NA
element, and give an error if none works. Otherwise, the processing is via
\code{strptime()} whose help page describes available conversion specifications.}

\item{tryFormats}{\verb{[character]}

Format strings to try if format is not specified.}
}
\value{
A \verb{<grates_isoweek>} object.
}
\description{
Generic for conversion to \verb{<grates_isoweek>}
}
\details{
\itemize{
\item Date, POSIXct, and POSIXlt are converted with the timezone respected.
\item Character objects are first coerced to date via \code{as.Date()} unless
\code{format = "yearweek"} in which case input is assumed to be in the form
"YYYY-Wxx" and parsed accordingly.
}
}
\examples{
as_isoweek(Sys.Date())
as_isoweek(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_isoweek("2019-05-03")
as_isoweek("2019-W12", format = "yearweek")

}
\seealso{
\code{new_isoweek()} and \code{as.Date()}.
}
