% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{make_distance_graph}
\alias{make_distance_graph}
\alias{make_relationship}
\alias{make_distance_adjmat}
\title{Generate Distance Matrix}
\usage{
make_distance_graph(graph, directed = TRUE, absolute = FALSE)

make_distance_adjmat(mat, directed = TRUE, absolute = FALSE)
}
\arguments{
\item{graph}{An \code{\link[igraph]{igraph}} object. May be directed or weighted.}

\item{directed}{logical. Whether directed information is passed to the distance matrix.}

\item{absolute}{logical. Whether distances are scaled as the absolute difference from the diameter (maximum possible). Defaults to TRUE. The alternative is to calculate a relative difference from the diameter for a geometric decay in distance.}

\item{mat}{precomputed adjacency or commonlink matrix.}
}
\value{
A numeric matrix of values in the range [0, 1] where lower values are closer
}
\description{
Compute the distance matrix of using shortest paths of a (directed) \code{\link[igraph]{igraph}} structure, normalising by the diameter of the network, preserving node/column/row names (and direction).
}
\examples{

library("igraph")
graph_test_edges <- rbind(c("A", "B"), c("B", "C"), c("B", "D"))
graph_test <- graph.edgelist(graph_test_edges, directed = TRUE)
adjacency_matrix <- make_adjmatrix_graph(graph_test)
distance_matrix <- make_distance_adjmat(adjacency_matrix)

}
\keyword{adjacency}
\keyword{graph}
\keyword{igraph}
\keyword{network}
